//=============================================================================
// RPGツクールMZ - RewardMentalPoint.js
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc 戦闘勝利時に精神力が1増加するようにします。
 * @author emoriiin979
 *
 * @help RewardMentalPoint.js
 *
 * プラグインコマンドはありません。
 */

(() => {
    "use strict";

    const rewardMentalPoint = 1;
    const maxMentalPoint = 100;
    const rewardMessage = "精神力が %1 上昇した！";

    //-------------------------------------------------------------------------
    // BattleManager

    const _BattleManager_makeRewards = BattleManager.makeRewards;
    BattleManager.makeRewards = function() {
        _BattleManager_makeRewards.call(this);
        this._rewards.mentalPoint = this.shouldAddMentalPoint() ? rewardMentalPoint : 0;
    };

    BattleManager.shouldAddMentalPoint = function() {
        for (const actor of $gameParty.allMembers()) {
            if (actor.mat < maxMentalPoint) {
                return true;
            }
        }
        return false;
    };

    BattleManager.displayRewards = function() {
        this.displayExp();
        this.displayGold();
        this.displayAddMentalPoint();
        this.displayDropItems();
    };

    BattleManager.displayAddMentalPoint = function() {
        const addMentalPoint = this._rewards.mentalPoint;
        if (addMentalPoint > 0) {
            $gameMessage.add("\\." + rewardMessage.format(rewardMentalPoint));
        }
    };

    BattleManager.gainRewards = function() {
        this.gainExp();
        this.gainGold();
        this.gainMentalPoint();
        this.gainDropItems();
    };

    BattleManager.gainMentalPoint = function() {
        for (const actor of $gameParty.allMembers()) {
            actor.gainMentalPoint(rewardMentalPoint);
        }
    };

    //-------------------------------------------------------------------------
    // Game_Actor

    Game_Actor.prototype.gainMentalPoint = function(rewardMentalPoint) {
        if (this.mat < maxMentalPoint) {
            const addMentalPoint = Math.min(maxMentalPoint - this.mat, rewardMentalPoint);
            this.addParam(4, addMentalPoint);
        }
    };
})();
